<?php
require_once __DIR__ . '/config.php'; // تا بتوانیم متغیرهای دیتابیس را داشته باشیم

try {
    $pdo = new PDO(
        "mysql:host=$db_host;dbname=$db_name;charset=$charset",
        $db_user,
        $db_pass,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES $charset COLLATE utf8mb4_persian_ci"
        ]
    );
} catch (PDOException $e) {
    file_put_contents('db_errors.log', date('Y-m-d H:i:s').' - '.$e->getMessage().PHP_EOL, FILE_APPEND);
    die("خطا در اتصال به پایگاه داده!");
}
